<?php
/*
* 2007-2010 PrestaShop 
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author Prestashop SA <contact@prestashop.com>
*  @copyright  2007-2010 Prestashop SA
*  @version  Release: $Revision: 1.4 $
*  @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registred Trademark & Property of PrestaShop SA
*/

if (!defined('_CAN_LOAD_FILES_'))
	exit;

class BlockHeaderLogos extends Module
{
	protected $maxImageSize = 307200;
	
	public function __construct()
	{
		$this->name = 'blockheaderlogos';
		$this->tab = 'front_office_features';
		$this->version = 1.0;

		parent::__construct();
		
		$this->displayName = $this->l('Header logos');
		$this->description = '';
	}
	
	public function install()
	{
		if (!Configuration::get('BHL_HOMEPAGE_LOGO_HEIGHT'))
			Configuration::updateValue('BHL_HOMEPAGE_LOGO_HEIGHT', 71);
		if (!Configuration::get('BHL_HOMEPAGE_LOGO_WIDTH'))
			Configuration::updateValue('BHL_HOMEPAGE_LOGO_WIDTH', 215);
		if (!Configuration::get('BHL_HOMEPAGE_LOGO'))
			Configuration::updateValue('BHL_HOMEPAGE_LOGO', 'v2-logo.png');
		if (!Configuration::get('BHL_HOMEPAGE_AD_HEIGHT'))
			Configuration::updateValue('BHL_HOMEPAGE_AD_HEIGHT', 60);
		if (!Configuration::get('BHL_HOMEPAGE_AD_WIDTH'))
			Configuration::updateValue('BHL_HOMEPAGE_AD_WIDTH', 468);
		if (!Configuration::get('BHL_HOMEPAGE_AD'))
			Configuration::updateValue('BHL_HOMEPAGE_AD', 'v2-headerpub-en.gif');	
		return (parent::install() AND $this->registerHook('top'));
	}

	public function getContent()
	{
		if (Tools::isSubmit('submitUpdate'))
		{
			if (isset($_FILES['BHL_HOMEPAGE_LOGO']) AND isset($_FILES['BHL_HOMEPAGE_LOGO']['tmp_name']) AND !empty($_FILES['BHL_HOMEPAGE_LOGO']['tmp_name']))
				if (checkImage($_FILES['BHL_HOMEPAGE_LOGO'], $this->maxImageSize) == false)
					if (move_uploaded_file($_FILES['BHL_HOMEPAGE_LOGO']['tmp_name'], dirname(__FILE__).'/'.$_FILES['BHL_HOMEPAGE_LOGO']['name']))
						Configuration::updateValue('BHL_HOMEPAGE_LOGO', $_FILES['BHL_HOMEPAGE_LOGO']['name']);
			if (isset($_FILES['BHL_HOMEPAGE_AD']) AND isset($_FILES['BHL_HOMEPAGE_AD']['tmp_name']) AND !empty($_FILES['BHL_HOMEPAGE_AD']['tmp_name']))
				if (checkImage($_FILES['BHL_HOMEPAGE_AD'], $this->maxImageSize) == false)
					if (move_uploaded_file($_FILES['BHL_HOMEPAGE_AD']['tmp_name'], dirname(__FILE__).'/'.$_FILES['BHL_HOMEPAGE_AD']['name']))
						Configuration::updateValue('BHL_HOMEPAGE_AD', $_FILES['BHL_HOMEPAGE_AD']['name']);

			if (Configuration::get('BHL_HOMEPAGE_LOGO') AND file_exists(dirname(__FILE__).'/'.Configuration::get('BHL_HOMEPAGE_LOGO')))
			{
				list($width, $height, $type, $attr) = getimagesize(dirname(__FILE__).'/'.Configuration::get('BHL_HOMEPAGE_LOGO'));
				Configuration::updateValue('BHL_HOMEPAGE_LOGO_WIDTH', (int)round($width));
				Configuration::updateValue('BHL_HOMEPAGE_LOGO_HEIGHT', (int)round($height));
			}
			if (Configuration::get('BHL_HOMEPAGE_AD') AND file_exists(dirname(__FILE__).'/'.Configuration::get('BHL_HOMEPAGE_AD')))
			{
				list($width, $height, $type, $attr) = getimagesize(dirname(__FILE__).'/'.Configuration::get('BHL_HOMEPAGE_AD'));
				Configuration::updateValue('BHL_HOMEPAGE_AD_WIDTH', (int)round($width));
				Configuration::updateValue('BHL_HOMEPAGE_AD_HEIGHT', (int)round($height));
			}
			
			echo $this->displayConfirmation($this->l('Images updated successfully'));
		}
	
		$html = '
		<form method="post" action="'.htmlentities($_SERVER['REQUEST_URI']).'" enctype="multipart/form-data">
		<fieldset><legend>'.$this->displayName.'</legend>
			<label>'.$this->l('Homepage logo').'</label>
			<div class="margin-form">';
			if (Configuration::get('BHL_HOMEPAGE_LOGO') AND file_exists(dirname(__FILE__).'/'.Configuration::get('BHL_HOMEPAGE_LOGO')))
				$html .= '<div id="image" >
					<img src="'.$this->_path.Configuration::get('BHL_HOMEPAGE_LOGO').'?t='.time().'" />
					<p align="center">'.$this->l('Filesize').' '.(filesize(dirname(__FILE__).'/'.Configuration::get('BHL_HOMEPAGE_LOGO')) / 1000).'kb</p>
					<a href="'.htmlentities($_SERVER['REQUEST_URI']).'&deleteHomepageLogo">
						<img src="../img/admin/delete.gif" alt="'.$this->l('Delete').'" /> '.$this->l('Delete').'
					</a>
				</div>';
			$html .= '<input type="file" name="BHL_HOMEPAGE_LOGO" />
				<p style="clear: both">'.$this->l('Will appear on the top left of your shop').'</p>
			</div>
			<div class="clear">&nbsp;</div>
			<label>'.$this->l('Homepage ad').'</label>
			<div class="margin-form">';
			if (Configuration::get('BHL_HOMEPAGE_AD') AND file_exists(dirname(__FILE__).'/'.Configuration::get('BHL_HOMEPAGE_AD')))
				$html .= '<div id="image" >
					<img src="'.$this->_path.Configuration::get('BHL_HOMEPAGE_AD').'?t='.time().'" />
					<p align="center">'.$this->l('Filesize').' '.(filesize(dirname(__FILE__).'/'.Configuration::get('BHL_HOMEPAGE_AD')) / 1000).'kb</p>
					<a href="'.htmlentities($_SERVER['REQUEST_URI']).'&deleteHomepageAd">
						<img src="../img/admin/delete.gif" alt="'.$this->l('Delete').'" /> '.$this->l('Delete').'
					</a>
				</div>';
			$html .= '<input type="file" name="BHL_HOMEPAGE_AD" />
				<p style="clear: both">'.$this->l('Will appear on the top right of your shop').'</p>
			</div>
			<div class="clear"></div>
			<div class="margin-form clear"><input type="submit" name="submitUpdate" value="'.$this->l('Update images').'" class="button" /></div>
		</fieldset>
		</form>';
		
		return $html;
	}
	
	public function hookTop($params)
	{
		global $smarty;
		
		$smarty->assign(array(
			'BHL_HOMEPAGE_LOGO' => __PS_BASE_URI__.'modules/'.$this->name.'/'.Configuration::get('BHL_HOMEPAGE_LOGO'),
			'BHL_HOMEPAGE_LOGO_WIDTH' => (int)Configuration::get('BHL_HOMEPAGE_LOGO_WIDTH'),
			'BHL_HOMEPAGE_LOGO_HEIGHT' => (int)Configuration::get('BHL_HOMEPAGE_LOGO_HEIGHT'),
			'BHL_HOMEPAGE_AD' => __PS_BASE_URI__.'modules/'.$this->name.'/'.Configuration::get('BHL_HOMEPAGE_AD'),
			'BHL_HOMEPAGE_AD_WIDTH' => (int)Configuration::get('BHL_HOMEPAGE_AD_WIDTH'),
			'BHL_HOMEPAGE_AD_HEIGHT' => (int)Configuration::get('BHL_HOMEPAGE_AD_HEIGHT')
		));
		return $this->display(__FILE__, 'blockheaderlogos.tpl');
	}
}